require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

-- Initializes the current player name, and whether to delete the initial text
local playername = gEnterNameValue;

kDiffEasy = 0;
kDiffMedium = 1;
kDiffHard = 2;

MakeDialog
{
	name = "choosedifficulty",
	
	VTintWindow {
	    x = 0, y = 0, w = 800, h = 600,
        color = Color(0,0,0,150),
        time = 300,
        fade = true,
	},
		
	RBounceWindow {
	    x = 0,
	    y = kCenter - 600,
	    w = 800, 
	    h = 600,
	    targetposx	= 0,
		targetposy	= 0,
		bouncelen	= 300,
		bouncefunc	= "sincx",
		alpha = true,

	    KSplit9Image
	    { 
		    image = "ui/backgrounds/split9_dialog",	
		    x = kCenter,
		    y = kCenter,
		    w = 220,
		    h = 330,
		    x1 = 60,
		    y1 = 60,
		    x2 = 60,
		    y2 = 60,
    		
		    ---------------------------------------------- Title
		    Text
		    {
			    x		= 0,
			    y		= 30,
			    w		= kMax,
			    h		= 30,
			    font	= {edwardian_medium, 22, WhiteColor },
			    name	= "choose_difficulty_title",
			    flags	= kHAlignCenter + kVAlignTop,
			    label	= "choose_difficulty_title"
		    },
    		
            SetStyle(CSOvalGreenButtonStyle);
		    ---------------------------------------------- Easy
		    Button
		    {
			    x			= kCenter,
			    y			= 45,
			    --w			= 104,
			    --h			= 68,
			    label       = "diff_easy",			
			    type		= kPush,
			    default		= true,
			    command		= 
				    function()
				        ModalReturn(kDiffEasy);
				        PostMessage( CreateNamedMessage (kTintOff, "" ) );
				        DoTransition( kBounceThrough );
				        CloseWindow();
				        --PostMessage( CreateNamedMessage (kBounceThrough, "CloseWindow();" ) );
				    end
		    },
		    SetStyle(CSOvalAmberButtonStyle);
		    ---------------------------------------------- Medium
		    Button
		    {
			    x			= kCenter,
			    y			= 105,
			    --w			= 104,
			    --h			= 68,
			    label       = "diff_medium",			
			    type		= kPush,
			    command		= 
				    function()
				        ModalReturn(kDiffMedium);
				        PostMessage( CreateNamedMessage (kTintOff, "" ) );
				        DoTransition( kBounceThrough );
				        CloseWindow();
				    end
		    },
		    SetStyle(CSOvalRedButtonStyle);
		    ---------------------------------------------- Hard
		    Button
		    {
			    x			= kCenter,
			    y			= 165,
			    --w			= 104,
			    --h			= 68,
			    label       = "diff_hard",			
			    type		= kPush,
			    command		= 
				    function()   
				        ModalReturn(kDiffHard); 
				        PostMessage( CreateNamedMessage (kTintOff, "" ) );
				        DoTransition( kBounceThrough );
				        CloseWindow();
				    end
		    },
		    
		    SetStyle(CSOvalLightBlueButtonStyle);
		    ---------------------------------------------- Back
		    Button
		    {
			    x			= kCenter,
			    y			= 250,
			    --w			= 104,
			    --h			= 68,
			    label       = "app_back",			
			    type		= kPush,
			    command		= 
				    function()   
				        ModalReturn(-1); 
				        PostMessage( CreateNamedMessage (kTintOff, "" ) );
				        DoTransition( kBounceThrough );
				        CloseWindow();
				    end
		    },
	    },
    },
}